// MfcMidiFile.h : header file

// Uncomment this define if you want standard C buffered file I/O
// #define BUFFERED_IO

// Uncomment this define if you want an example of reading a MIDI file in RAM
// #define RAMFILE_IO

// Include the MIDIFILE.DLL header file. It defines the CMidiFile base class
#include "..\midifile.h"

// Definition of MfcMidiFile class
class MfcMidiFile: public CMidiFile
{
public:
	MfcMidiFile();
	void 			LoadMidi(const char * Filename);

private:
	unsigned long	Packet;

	void			FormatTime(char * Buffer);
	void			AddToList(char * Buffer);

	// The Callbacks
#ifdef BUFFERED_IO
	long APIENTRY	OnReadWriteMidi(unsigned char * Buffer, unsigned long Count);
	long APIENTRY	OnOpenMidi();
	long APIENTRY	OnSeekMidi(long Offset);
	long APIENTRY	OnCloseMidi();
#endif
#ifdef RAMFILE_IO
	long APIENTRY	OnReadWriteMidi(unsigned char * Buffer, unsigned long Count);
	long APIENTRY	OnOpenMidi();
	long APIENTRY	OnSeekMidi(long Offset);
	long APIENTRY	OnCloseMidi();
#endif
	long APIENTRY	OnStartMThd();
	long APIENTRY	OnStartMTrk();
	long APIENTRY	OnUnknownChunk();
	long APIENTRY	OnMetaText();
	long APIENTRY	OnSysexEvt();
	long APIENTRY	OnStandardEvt();
	long APIENTRY	OnMetaSeqNum();
	long APIENTRY	OnMetaTimeSig();
	long APIENTRY	OnMetaKeySig();
	long APIENTRY	OnMetaTempo();
	long APIENTRY	OnMetaSMPTE();
	long APIENTRY	OnMetaEOT();
	long APIENTRY	OnMetaPort();
	long APIENTRY	OnMetaChan();
};


// An instance of MfcMidiFile (found in MfcMidiFile.cpp)
extern MfcMidiFile	MyCMidiFile;