/*
This uses the high level WAVE API PlaySound() to play a WAVE file in memory. I simply
open the WAVE file called "C:\\WINDOWS\\CHORD.WAV" (ie, in order for this example to
work, you should make sure that you have such a WAVE file on your system). allocate
some memory to completely load the entire file image into memory, and then use that
for PlaySound().
*/

#include <windows.h>
#include <stdio.h>
#include <conio.h>

#include <winreg.h>
#include <mmsystem.h>



TCHAR		WaveName[] = "C:\\WINDOWS\\CHORD.WAV";










/********************************** main() *******************************/

int main(int argc, char **argv)
{
	HANDLE			inHandle;
	char *			wavePtr;
	unsigned long	waveSize, action;

	/* Open the WAVE file */
	if (INVALID_HANDLE_VALUE != (inHandle = CreateFile("C:\\WINDOWS\\CHORD.WAV", GENERIC_READ,
		FILE_SHARE_READ, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN, 0)))
	{
		/* I'm going to skip checking that this is a WAVE file. I'll assume that it is.
		 *	Normally, you'd check it's RIFF header.
		 */

		/* Get the size of the file */
		if(0xFFFFFFFF != (waveSize = GetFileSize(inHandle, 0)) && waveSize)
		{
			/* Allocate some memory to load the file */
			if ((wavePtr = (char *)VirtualAlloc(0, waveSize, MEM_COMMIT, PAGE_READWRITE)))
			{
				/* Read in WAVE file */
				if (ReadFile(inHandle, wavePtr, waveSize, &action, 0) && waveSize == action)
				{
					/* Play the WAVE */
					if (!PlaySound((LPCSTR)wavePtr, 0, SND_MEMORY | SND_NODEFAULT))
					{
						printf("Error playing WAVE!\r\n");
					}
				}
				else
				{
					printf("Error loading WAVE!\r\n");
				}

				/* Free the memory */
				VirtualFree(wavePtr, waveSize, MEM_FREE);
			}
			else
			{
				printf("Can't get memory!\r\n");
			}
		}
		else
		{
			printf("Bad WAVE size!\r\n");
		}

		/* Close the WAVE file */
		CloseHandle(inHandle);
	}
	else
	{
		printf("Can't load the WAVE file!\r\n");
	}

	return(0);
}
