/*
 * You must link with winmm.lib. If using Visual C++, go to Build->Settings. Flip to the
 * Link page, and add winmm.lib to the library/object modules.
 *
 * This example plays the WAVE file named C:\WINDOWS\TEST.WAVE using the Wave Audio device
 * (ie, High level Digital Audio API). It demonstrates both the string and command interfaces,
 * to play the wave twice (once using each interface).
 */

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <mmsystem.h>





/*********************** PrintWaveOutErrorMsg() **************************
 * Retrieves and displays an error message for the passed Wave Out error
 * number. It does this using mciGetErrorString().
 *************************************************************************/

void PrintWaveOutErrorMsg(DWORD err, TCHAR * str)
{
#define BUFFERSIZE 128
	char	buffer[BUFFERSIZE];
	
	printf("ERROR: %s\r\n", str);
	if (mciGetErrorString(err, &buffer[0], sizeof(buffer)))
	{
		printf("%s\r\n", &buffer[0]);
	}
	else
	{
		printf("0x%08X returned!\r\n", err);
	}
}





/* ******************************** main() ******************************** */

int main(int argc, char **argv)
{
	DWORD				err;
	MCI_WAVE_OPEN_PARMS	waveParams;

	/*	Specify the Wave Audio device as the type of device. It's true that, because we're also going to ask
		to open a WAVE filename that ends with a .WAV and this extension undoubtably has a registry
		association with the Wave Audio Device, we don't really need to set this field, nor specify the
		MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID flags. But it doesn't hurt to play it safe by explicitly asking for
		the Wave Audio device.
	*/
	waveParams.lpstrDeviceType = (LPCSTR)MCI_DEVTYPE_WAVEFORM_AUDIO;
	
	/* Specify the WAVE file we wish operated upon (ie, played) */
	waveParams.lpstrElementName = "C:\\WINDOWS\\CHORD.WAV";

	/* Open a Wave Audio device, associating it with C:\WINDOWS\CHORD.WAV, and wait for the operation to complete */
	if ((err = mciSendCommand(0, MCI_OPEN, MCI_WAIT|MCI_OPEN_ELEMENT|MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)(LPVOID)&waveParams)))
	{
		/* Error */
		PrintWaveOutErrorMsg(err, "mciSendCommand() did not open the Wave Audio device!");

		/* Exit the program */
		return(-1);
	}

	/* The device opened successfully. waveParams.wDeviceID now contains the device ID */

	/* Play the waveform (from beginning to end), and wait for this operation to complete */
	if ((err = mciSendCommand(waveParams.wDeviceID, MCI_PLAY, MCI_WAIT, (DWORD)(LPVOID)&waveParams)))
	{
		/* Error */
		PrintWaveOutErrorMsg(err, "mciSendCommand() did not play the waveform!");
	}

	/* Close the device, and wait for this operation to complete */
	mciSendCommand(waveParams.wDeviceID, MCI_CLOSE, MCI_WAIT, (DWORD)(LPVOID)&waveParams);


	/* =================================================================== */

	/* Now do the same thing as above, but this time, let's use the string
	 * interface of mciSendString(), rather than mciSendCommand().
	 */

	/* Open a Wave Audio device, associating it with TEST.WAV, and wait for the operation to complete */
	if ((err = mciSendString("open waveaudio!c:\\windows\\chord.wav alias mysound wait", 0, 0, 0)))
	{
		/* Error */
		PrintWaveOutErrorMsg(err, "mciSendString() did not open the Wave Audio device!");

		/* Exit the program */
		return(-1);
	}

	/* The device opened successfully. we now use the alias "mysound" to reference the device */

	/* Play the waveform (from beginning to end), and wait for this operation to complete */
	if ((err = mciSendString("play mysound from 0 wait", 0, 0, 0)))
	{
		/* Error */
		PrintWaveOutErrorMsg(err, "mciSendString() did not play the waveform!");
	}

	/* Close the device, and wait for this operation to complete */
	mciSendString("close mysound wait", 0, 0, 0);

	return(0);
}