/* ===========================================================================
 * mfvlq.c
 *
 * Converts the variable length quantity typed by the user into a LONG and displays that.
 * =========================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "..\midifile.h"





/*********************************** main() *********************************
 * Program entry point. Calls the MIDIFILE.DLL function MidiVLQToLong.
 ****************************************************************************/

void main(int argc, char *argv[], char *envp[])
{
	register unsigned short	i;
	unsigned long			conv, final;
	unsigned char			buffer[16];
	register unsigned char * ptr;
	unsigned char *			arg;

	/* A buffer to hold user input */

	/* If no args supplied by user, exit with usage info */
	if (argc < 2)
	{
		printf("This program converts the variable length quantity\r\n");
		printf("(ie, series of bytes) into an unsigned long and\r\ndisplays that.\r\n\n");
		printf("Syntax: MFVLQ.EXE [...bytes...]\r\n");
		exit(1);
	}

	/* Convert ascii numerals to Variable Length byte values, and store in buffer */
	if (argc > 15) argc = 15;	/* Just for safety -- Variable length quantities should never be more than this many bytes anyway */
	ptr = &buffer[0];
	for (i = 1; i < argc; i++)
	{
		arg = argv[i];
		*(ptr)++ = (unsigned char)strtoul((const char *)arg, (char **)&arg, 0) | 0x80;
	}

	/* The last byte of variable length must have bit #7 clear */
	*(ptr-1) &= 0x7F;

	/* Call MIDIFILE.DLL function to do the conversion, and print it  */
	final = MidiVLQToLong(&buffer[0], &conv);
	printf("Value = 0x%08lx\r\n%ld bytes converted\r\n", final, conv);

	exit(0);
}
