/* ===========================================================================
 * mfvlq.c
 *
 * Converts ULONGs entered by the user into the variable length quantity equivalent and
 * displays that.
 * =========================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "..\midifile.h"






/********************************** main() ********************************
 * Program entry point. Calls the MIDIFILE.DLL function MidiVLQToLong.
 **************************************************************************/

void main(int argc, char *argv[], char *envp[])
{
	register unsigned short	i;
	unsigned long			conv, len;
	unsigned char			buffer[6];
	unsigned char *			arg;

	/* If no args supplied by user, exit with usage info */
	if ( argc < 2 )
	{
		printf("This program converts ULONGs into the variable length\r\n");
		printf("quantity (ie, series of bytes) equivalent and displays that.\r\n");
		printf("Syntax: MFTOVLQ.EXE [ULONG1 ULONG2...]\r\n");
		exit(1);
	}

	for (i=1; i<argc; i++)
	{
		/* Convert ascii numerals to a binary long */
		arg = argv[i];
		conv = strtoul((const char *)arg, (char **)&arg, 0);

		/* Call MIDIFILE.DLL function to do the conversion to Variable Length quantity */
		len = MidiLongToVLQ(conv, &buffer[0]);

		/* Format the variable length bytes as ascii and print out */
		printf("%10s = ", argv[i]);
		arg = &buffer[0];
		while (len--)
		{
			printf("0x%02x ", (unsigned long)*(arg)++);
		}
		printf("\r\n");
	}

	exit(0);
}
