/* SavePgms.c
 *
 * An example of using GENMIDI.DLL.
 *
 * This example shows how to call the DLL function MidiSaveDat()
 * to save an Instrument/Bank/Program.
 */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "..\genmidi.h"

/***************************** main() ********************************/

void main(int argc, char *argv[])
{
	unsigned char *	addArray[3];
	unsigned char *	ptr;
	unsigned long	loop;
	unsigned char	i, pgmNum, insNum;
	unsigned short	bankNum;
	unsigned char	buffer[120];

	/* Check if any parameters were given, if not, display some help info */
	if (argc < 2)
	{
		_cputs("Saves an Instrument/Bank/Program within the database.\r\n\nSyntax is ");
		_cputs("'SAVEPGMS Filename [Instrument Bank Program]'.\r\n\t where Filename is the file to save.\r\n");
		_cputs("\t where Instrument is the instrument name to save.\r\n");
		_cputs("\t where Bank is the bank name to save\r\n\t\t within that Instrument.\r\n");
		_cputs("\t where Program is the program name to save\r\n\t\t within that Instrument and Bank.\r\n");
		_cputs("Use double quotes if a name contains spaces.\r\n");
		_cputs("Version 1.0\r\n");
		exit(0);
	}

	/* Assume user didn't specify any Instrument, Bank, or Program */
	addArray[0] = addArray[1] = addArray[2] = 0;
	i = 0;

	/* Parse command line args */
	for (loop=2; loop < (unsigned long)argc; loop++)
	{
		/* Instrument, Bank, Program, or Note name to create/modify */
		if (i < 3)
		{
			addArray[i] = argv[loop];
			i++;
		}
	}

	/* Lock the database before we save */
	if (!MidiLock(MIDILOCK_ACCESS, MIDILOCK_WAITFOREVER))
	{
		/* Assume saving an instrument */
		i = 1;

		/* An Instrument name supplied? */
		if (addArray[0])
		{
			/* Check if this instrument name is already in the database, and get its number */
			insNum = (unsigned char)MidiGetInstrumentNum(addArray[0]);

			/* If Instrument wasn't found then an error */
			if (insNum == 0xFF)
			{
				_cputs("ERROR: Can't find '");
				_cputs(addArray[0]);
				_cputs("' instrument!\r\n");
				MidiUnlock();
				exit(-1);
			}

			/* Save the pointer set up by DLL for use with MidiSaveDat() */
			ptr = MidiNames.Instrument;
		}

		/* No Instrument name supplied, so just get the first instrument (ie, we're going to save that
		   instrument) */
		else
		{
			if ((insNum = (unsigned char)MidiNextInstrument(&addArray[0])) == 0xFF)
			{
				_cputs("ERROR: No instruments in database!\r\n");
				MidiUnlock();
				exit(-2);
			}
		}

		/* A bank name supplied? */
		if (addArray[1])
		{
			/* Check if this bank name is already in the instrument, and get its number */
			bankNum = (unsigned short)MidiGetBankNum(addArray[1], insNum);

			/* If bank wasn't found then an error */
			if (bankNum == 0xFFFF)
			{
				_cputs("ERROR: Can't find '");
				_cputs(addArray[1]);
				_cputs("' bank!\r\n");
				MidiUnlock();
				exit(-3);
			}

			/* Save the pointer set up by DLL for use with MidiSaveDat() */
			ptr = MidiNames.Bank;

			/* Saving a bank */
			i = 2;
		}

		/* A program name supplied? */
		if (addArray[2])
		{
			/* Check if this program name is already in the bank, and get its number */
			pgmNum = MidiGetPgmNum(addArray[2], bankNum, insNum);

			/* If program wasn't found then an error */
			if (pgmNum == 0xFF)
			{
				_cputs("ERROR: Can't find '");
				_cputs(addArray[2]);
				_cputs("' program!\r\n");
				MidiUnlock();
				exit(-4);
			}

			/* Save the pointer set up by DLL for use with MidiSaveDat() */
			ptr = MidiNames.Pgm;

			/* Saving a program */
			i = 3;
		}

		/* Save the Instrument/Bank/Program to the specified filename */
		if ((loop = MidiSaveDat(argv[1], ptr, i)))
		{
			_cputs("ERROR: ");
			_cputs(MidiGenError(&buffer[0], 120, loop));
			_cputs("\r\n");
			MidiUnlock();
			exit(-5);
		}
		
		/* Unlock the database after saving */
		MidiUnlock();
	}

	exit(0);
}
