/* DumpPgms.c
 *
 * An example of using GENMIDI.DLL.
 *
 * This example shows how to call the DLL functions MidiNextInstrument(),
 * MidiNextBank(), MidiNextPgm(). and MidiNextNote() to retrieve and display
 * all Instrument, Bank, Program and Note (ie, for example, Drum Key) names
 * in the DLL's loaded database.
 */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "..\genmidi.h"

long	lines = 0;
long	count = 1;


/************************** check_pause() ****************************
 * Check if we have filled the screen. If so, pause output waiting for
 * the user to press a key to continue.
 *********************************************************************/

void check_pause(long more)
{
	/* User wants the pause feature (ie, lines is not 0), and we filled the screen? */
	count += more;
	if (lines && (count >= lines))
	{
		count = 1;
		_cputs("--- Press ENTER to continue ---");
		getchar();
		_cputs("\r\n");
	}
}



/***************************** main() ********************************/

void main(int argc, char *argv[])
{
	unsigned char * insName;
	unsigned char * bankName;
	unsigned char * pgmName;
	unsigned char * noteName;
	unsigned char * pgmStruct;
	unsigned char * noteStruct;
	unsigned long	loop;

	/* Parse command line args */
	for (loop=1; loop < (unsigned long)argc; loop++)
	{
		/* An option? */
		bankName = argv[loop];
		if (*bankName == '/')
		{
			bankName++;
			switch ((*bankName) & 0x5F)
			{
				/* Screen lines */
				case 'L':
					lines = atol(bankName+1);
			}
		}
	}

	/* Indicate that we're accessing the database, but don't lock out other programs */
	if (!MidiLock(MIDILOCK_ACCESS, MIDILOCK_WAITFOREVER))
	{

		/* Start with first instrument */
		insName = 0;

		/* Get next Instrument name */
		while (MidiNextInstrument(&insName) != 0xFFFF)
		{
			/* Print the instrument name */
			_cputs("===============================================================\r\n");
			_cputs(insName);
			_cputs("\r\n");

			check_pause(3);

			/* Start with first bank */
			bankName = 0;

			/* Get next Bank name */
			while (MidiNextBank(&bankName, insName) != 0xFFFFFFFF)
			{
				/* Print the Bank name */
				_cputs("\t-------------------------------------------------------\r\n\t");
				_cputs(bankName);
				_cputs("\r\n\t-------------------------------------------------------\r\n");

				check_pause(3);

				pgmStruct = 0;

				/* Get the next program name */
				while (MidiNextPgm(&pgmName, bankName, &pgmStruct) != 0xFFFF)
				{
					/* Print the program name */
					_cputs("\t\t");
					_cputs(pgmName);
					_cputs("\r\n");

					check_pause(1);

					noteStruct = 0;
					/* Get the next note name */
					while (MidiNextNote(&noteName, pgmName, &noteStruct) < 128)
					{
						/* Print the note name */
						_cputs("\t\t\t");
						_cputs(noteName);
						_cputs("\r\n");

						check_pause(1);
					}
				}
			}
		}

		/* Indicate that we're done accessing the database */
		MidiUnlock();

	}

	exit(0);
}
